//
//  OPShareHelper.h
//  OnePasswordiOS
//
//  Created by Roustem Karimov on 2013-05-25.
//  Copyright (c) 2013 AgileBits. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <OnePasswordDataModel/OnePasswordDataModel.h>

@interface OPItemFormatter : NSObject

@property (nonatomic, readonly) OPItem *item;
@property (nonatomic, readonly) NSData *scrambledData;


- (id)initWithItem:(OPItem *)item;
- (id)initWithScrambledData:(NSData *)scrambledData profile:(id<OPGenericProfile>)profile;
+ (instancetype)formatterWithShareURL:(NSURL *)shareURL profile:(id<OPGenericProfile>)profile;

- (NSString *)htmlText;
- (NSString *)htmlLink;
- (NSString *)plainText;
- (NSString *)plainLink;
- (NSString *)printText;
- (NSString *)plainURLText;

@end
